/* 
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA 02110-1301  USA
 */
#ifndef _MFORMS_SPLITTER_H_
#define _MFORMS_SPLITTER_H_

#include <mforms/view.h>
#include <map>

namespace mforms {
  
  class Splitter;
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS
#ifndef SWIG
  struct SplitterImplPtrs
  {
    bool (__stdcall *create)(Splitter *self, bool horizontal);
    void (__stdcall *add)(Splitter *self, View *child, int minsize);
    void (__stdcall *remove)(Splitter *self, View *child);
    void (__stdcall *set_position)(Splitter *self, int);
    int (__stdcall *get_position)(Splitter *self);
  };
#endif
#endif
  
  /** A splitter/splitview/paned view to accommodate 2 child views with a dragable divider */
  class MFORMS_EXPORT Splitter : public View
  {
  public:
    /** Constructor.
     
     @param horiz - whether child views should be placed side by side or below the other */
    Splitter(bool horiz);
    
    /** Adds a child view, only 2 child views can be added.

     @param minsize - minimal size this view can have */
    void add(View *subview, int minsize=0);
    
    /** Remove a child view */
    virtual void remove(View *subview);
    
    /** Sets/gets position of the divider */
    void set_position(int position);
    int get_position();

  protected:
    SplitterImplPtrs *_splitter_impl;
  };
  
};

#endif /* _MFORMS_SPLITTER_H_ */
