/* 
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _WebBROWSER_H_
#define _WebBROWSER_H_

#include <mforms/view.h>

namespace mforms {

#ifndef DOXYGEN_SHOULD_SKIP_THIS
#ifndef SWIG
  class WebBrowser;

  struct MFORMS_EXPORT WebBrowserImplPtrs
  {
    bool (__stdcall *create)(WebBrowser*);
    void (__stdcall *set_html)(WebBrowser*, const std::string&);
    void (__stdcall *navigate)(WebBrowser*, const std::string&);
    std::string (__stdcall *get_document_title)(WebBrowser*);
  };
#endif
#endif

  /** HTML browser.
   
   This is implemented using the native Browser widget (IE in Windows and WebKit in Mac)
   Currently not supported in Linux */
  class MFORMS_EXPORT WebBrowser : public View
  {
  public:
    WebBrowser();

    /** Sets an HTML file to be displayed */
    void set_html(const std::string &path);
    /** Opens given URL in the brower */
    void navigate(const std::string &url);
    /** Gets the title of the displayed document */
    std::string get_document_title();

#ifndef SWIG
    /** Signal emitted when the document finishes loading 
     
     In Python use add_loaded_callback()
     */
    sigc::signal<void, const std::string&> &signal_loaded() { return _document_loaded; }
#ifndef DOXYGEN_SHOULD_SKIP_THIS
    virtual void document_loaded(const std::string& actualUrl);
#endif
#endif
  protected:
    WebBrowserImplPtrs *_webbrowser_impl;
    sigc::signal<void, const std::string&> _document_loaded;
  };
};

#endif // #fndef _WebBROWSER_H_
