/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _STUB_CHECKBOX_H_
#define _STUB_CHECKBOX_H_

#include <mforms/mforms.h>

#include "stub_button.h"

namespace mforms {
namespace stub {

class CheckBoxImpl : public ButtonImpl
{
 protected:
  static bool __stdcall create(::mforms::CheckBox *self)
  {
    return true;
  }

  static void __stdcall set_active(::mforms::CheckBox *self, bool flag)
  {
  }

  static bool __stdcall get_active(::mforms::CheckBox *self)
  {
    return false;
  }

  CheckBoxImpl(::mforms::CheckBox *self)
    : ButtonImpl(self)
  {
  }

  static void __stdcall callback(::mforms::CheckBox* self)
  {
  }

 public:
  static void init()
  {
    ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

    f->_checkbox_impl.create     = &CheckBoxImpl::create;
    f->_checkbox_impl.set_active = &CheckBoxImpl::set_active;
    f->_checkbox_impl.get_active = &CheckBoxImpl::get_active;
  }
};

};
};

#endif
