/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _STUB_IMAGEBOX_H_
#define _STUB_IMAGEBOX_H_

#include "mforms/label.h"

#include "stub_view.h"
#include "mforms/app.h"

namespace mforms {
namespace stub {

class ImageBoxImpl : public ViewImpl
{
protected:
  ImageBoxImpl(::mforms::ImageBox *self)
    : ViewImpl(self)
  {
  }

  static bool __stdcall create(::mforms::ImageBox *self)
  {
    return true;
  }

  static void __stdcall set_image(::mforms::ImageBox *self, const std::string &file)
  {
  }

 public:
  static void init()
  {
    ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

    f->_imagebox_impl.create         = &ImageBoxImpl::create;
    f->_imagebox_impl.set_image      = &ImageBoxImpl::set_image;
  }
};

};
};


#endif /* _STUB_IMAGEBOX_H_ */
