/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _STUB_LABEL_H_
#define _STUB_LABEL_H_


#include "mforms/label.h"

#include "stub_view.h"

namespace mforms {
namespace stub {

class LabelImpl : public ViewImpl
{
protected:
  LabelImpl(::mforms::Label *self)
    : ViewImpl(self)
  {
  }

  static bool __stdcall create(::mforms::Label *self)
  {
    return true;
  }

  static void __stdcall set_style(::mforms::Label *self, ::mforms::LabelStyle style)
  {
  }

  static void __stdcall set_text(::mforms::Label *self, const std::string &text)
  {
  }

  static void __stdcall set_color(::mforms::Label *self, const std::string &text)
  {
  }

  static void __stdcall set_wrap_text(::mforms::Label *self, bool flag)
  {
  }

  static void __stdcall set_text_align(::mforms::Label *self, ::mforms::Alignment align)
  {
  }

 public:
  static void init()
  {
    ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

    f->_label_impl.create         = &LabelImpl::create;
    f->_label_impl.set_style      = &LabelImpl::set_style;
    f->_label_impl.set_text       = &LabelImpl::set_text;
    f->_label_impl.set_text_align = &LabelImpl::set_text_align;
    f->_label_impl.set_color      = &LabelImpl::set_color;
    f->_label_impl.set_wrap_text  = &LabelImpl::set_wrap_text;
  }
};

};
};


#endif
