/* 
 * ©2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _STUB_WIZARD_H_
#define _STUB_WIZARD_H_

#include <mforms/mforms.h>

#include "stub_base.h"
#include "stub_mforms.h"

namespace mforms
{
namespace stub
{

class WizardImpl : public ObjectImpl
{
    void refresh_step_list(const std::vector<std::string> &steps);
  
    static void __stdcall cancel(::mforms::Wizard* wiz);
  protected:
    WizardImpl(::mforms::Wizard *wiz);
    
    static bool __stdcall create(::mforms::Wizard *self);
    static void __stdcall set_title(::mforms::Wizard *self, const std::string &title);
    static void __stdcall run_modal(::mforms::Wizard *self);
    static void __stdcall close(::mforms::Wizard *self);
    static void __stdcall flush_events(::mforms::Wizard *self);
    static void __stdcall set_content(::mforms::Wizard *self, View *view);
    static void __stdcall set_heading(::mforms::Wizard *self, const std::string &);
    static void __stdcall set_step_list(::mforms::Wizard *self, const std::vector<std::string> &);
    static void __stdcall set_allow_cancel(::mforms::Wizard *self, bool flag);
    static void __stdcall set_allow_back(::mforms::Wizard *self, bool flag);
    static void __stdcall set_allow_next(::mforms::Wizard *self, bool flag);
    static void __stdcall set_show_extra(::mforms::Wizard *self, bool flag);
    static void __stdcall set_extra_caption(::mforms::Wizard *self, const std::string &);
    static void __stdcall set_next_caption(::mforms::Wizard *self, const std::string &);

public:
  static void init();
  
  static void set_icon_path(const std::string &path);
};

}//end of stub namespace
}//end of mforms namespace


#endif
