/* 
 * © 2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include "stdafx.h"
#include "wf_button.h"

using namespace MySQL;
using namespace MySQL::Forms;

//-------------------------------------------------------------------------------------------------

ButtonImpl::ButtonImpl(::mforms::Button *self)
  : ViewImpl(self)
{
}

//-------------------------------------------------------------------------------------------------

bool ButtonImpl::create(::mforms::Button *self, ::mforms::ButtonType btype)
{
  ButtonImpl ^button= gcnew ButtonImpl(self);

  if (button != nullptr)
  {
    Button^ native_button= ViewImpl::create<Button>(self, button);
    native_button->AutoSize= true;
    native_button->AutoSizeMode= AutoSizeMode::GrowAndShrink;
    native_button->UseMnemonic= true;
    if (btype == mforms::ToolButton)
    {
      native_button->FlatStyle = FlatStyle::Flat;
      native_button->TabStop = false;
      native_button->Text = "";
      native_button->FlatAppearance->BorderSize = 0;
    }
    native_button->Click += gcnew System::EventHandler(&ButtonImpl::button_click);
    return true;
  }
  return false;
}

//-------------------------------------------------------------------------------------------------

void ButtonImpl::set_text(::mforms::Button *self, const std::string &text)
{
  ButtonImpl^ button= (ButtonImpl^)ObjectImpl::FromUnmanaged(self);

  if (button != nullptr)
  {
    // Note: DON'T try to replace underscores by ampersand to make the UI interpreting
    //       them as mnemonic chars (in conjunction with the following character).
    //       Underscores are VALID characters and here is the wrong place to handle this.
    //       Only the caller can know the context and has to do such replacements.
    Control^ control= button->get_control<Control>();
    control->Text= CppStringToNative(text);

    // Resize the button to fit its content.
    Size size= control->PreferredSize;
    if (size.Width < control->Width)
      size.Width= control->Width;
    if (size.Height < control->Height)
      size.Height= control->Height;
    control->Size= size;

    if (control->Padding.Left == 0 && button->_internal_padding)
      enable_internal_padding(self, true);
  }
}

//-------------------------------------------------------------------------------------------------

void ButtonImpl::set_icon(::mforms::Button *self, const std::string &icon)
{
  ButtonImpl^ button= (ButtonImpl^)ObjectImpl::FromUnmanaged(self);

  if (button != nullptr)
  {
    Button^ control= button->get_control<Button>();
    String^ path = CppStringToNative(mforms::App::get()->get_resource_path(icon));
    if (IO::File::Exists(path))
      try
      {
        control->Image = Image::FromFile(path);

        // Resize the button to fit its content.
        Size size= control->PreferredSize;
        if (size.Width < control->Width)
          size.Width= control->Width;
        if (size.Height < control->Height)
          size.Height= control->Height;
        control->Size= size;
      }
      catch (...)
      {
        mforms::Utilities::show_error(_("Error while loading image"), _("An error occured while loading image ")
          + icon, _("Close"));
      }
  }
}
//-------------------------------------------------------------------------------------------------

void ButtonImpl::button_click(System::Object ^sender, System::EventArgs ^e)
{
  Windows::Forms::Button^ btn= (Windows::Forms::Button^)sender;

  if (btn->Tag != nullptr)
  {
    ::mforms::Button* button= ViewImpl::get_backend_control<::mforms::Button>(btn);
    if (button != 0)
      button->callback();
  }
}

//-------------------------------------------------------------------------------------------------

void ButtonImpl::enable_internal_padding(::mforms::Button *self, bool flag)
{
  ButtonImpl^ button= (ButtonImpl^)ObjectImpl::FromUnmanaged(self);

  // The internal padding feature is just some beautfying added to the button
  // gives it a bit more room left and right of the text than what is the default
  // for it.
  
  Button^ native_button= button->get_control<Button>();
  if (flag)
  {
    if (native_button->Padding.Left == 0)
    {
      // Only add extra padding if that didn't happen already.
      int extra= native_button->Height / 2;
      native_button->Padding= Padding::Add(native_button->Padding, Padding(extra, 0, extra, 0));
    }
  }
  else
  {
    native_button->Padding= Padding(0, 0, 0, 0);
  }

  button->_internal_padding= flag;
}

//-------------------------------------------------------------------------------------------------

