/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "stdafx.h"
#include "wf_imagebox.h"

using namespace System;
using namespace Drawing;
using namespace Windows::Forms;

using namespace mforms;
using namespace MySQL::Forms;

//--------------------------------------------------------------------------------------------------

ImageBoxImpl::ImageBoxImpl(ImageBox *image)
  : ViewImpl(image)
{
}

//--------------------------------------------------------------------------------------------------

bool ImageBoxImpl::create(ImageBox *self)
{
  ImageBoxImpl ^cb= gcnew ImageBoxImpl(self);

  if (cb != nullptr)
  {
    PictureBox ^pb= ViewImpl::create<PictureBox>(self, cb);
    pb->SizeMode = PictureBoxSizeMode::AutoSize;
    return true;
  }
  return false;
}

//--------------------------------------------------------------------------------------------------

void ImageBoxImpl::set_image(ImageBox *self, const std::string &file)
{
  ImageBoxImpl^ imageBox= (ImageBoxImpl^) ObjectImpl::FromUnmanaged(self);

  if (imageBox != nullptr && !file.empty())
  {
    PictureBox^ box= imageBox->get_control<PictureBox>();
    String^ name= CppStringToNative(mforms::App::get()->get_resource_path(file));

    try
    {
      if (IO::File::Exists(name))
        box->Load(name);
      else
        box->Load(Application::StartupPath + "\\" + name);
    }
    catch (...)
    {
      mforms::Utilities::show_error(_("Error while loading image"), _("An error occured while loading image ")
        + file, _("Close"));
    }
  }
}

//--------------------------------------------------------------------------------------------------

void ImageBoxImpl::set_image_align(ImageBox *self, Alignment alignment)
{
  // not supported on Windows. Align an auto-sized image box in a container instead.
}


//--------------------------------------------------------------------------------------------------

void ImageBoxImpl::set_scale_contents(ImageBox *self, bool flag)
{
  ImageBoxImpl^ imageBox= (ImageBoxImpl^) ObjectImpl::FromUnmanaged(self);

  if (imageBox != nullptr)
  {
    PictureBox^ box= imageBox->get_control<PictureBox>();
    if (flag)
      box->SizeMode = PictureBoxSizeMode::StretchImage;
    else
      box->SizeMode = PictureBoxSizeMode::AutoSize;
  }
}

//--------------------------------------------------------------------------------------------------
