/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _WF_RADIOBUTTON_H_
#define _WF_RADIOBUTTON_H_

#include <mforms/mforms.h>

#include "wf_button.h"


using namespace System;
using namespace Windows::Forms;

namespace MySQL {
  namespace Forms {

    public ref class RadioButtonImpl : public ButtonImpl
    {
      static bool create(::mforms::RadioButton *self, int)
      {
        RadioButtonImpl ^rb= gcnew RadioButtonImpl(self);

        if (rb != nullptr)
        {
          RadioButton^ button= ViewImpl::create<RadioButton>(self, rb);
          button->Click += gcnew System::EventHandler(&RadioButtonImpl::click);
          return true;
        }
        return false;
      }

      static void click(System::Object ^sender, System::EventArgs ^e)
      {
        Windows::Forms::RadioButton^ btn= (Windows::Forms::RadioButton^)sender;

        if (btn->Tag != nullptr)
        {
          ::mforms::Button* button= ViewImpl::get_backend_control<::mforms::Button>(btn);
          if (button != 0)
            button->callback();
        }
      }

      static void set_active(::mforms::RadioButton *self, bool flag)
      {
        RadioButtonImpl^ rb= (RadioButtonImpl^)ObjectImpl::FromUnmanaged(self);

        if (rb != nullptr)
        {
          rb->get_control<RadioButton>()->Checked= flag;
        }
      }

      static bool get_active(::mforms::RadioButton *self)
      {
        RadioButtonImpl^ rb= (RadioButtonImpl^)ObjectImpl::FromUnmanaged(self);

        if (rb != nullptr)
        {
          return rb->get_control<RadioButton>()->Checked;
        }
        return false;
      }

      RadioButtonImpl(::mforms::RadioButton *button)
        : ButtonImpl(button)
      {
      }

    public:
      static void init(Manager ^mgr)
      {
        ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

        DEF_CALLBACK2(bool, ::mforms::RadioButton*, int, mgr, f->_radio_impl, RadioButtonImpl, create);
        DEF_CALLBACK2(void, ::mforms::RadioButton*, bool, mgr, f->_radio_impl, RadioButtonImpl, set_active);
        DEF_CALLBACK1(bool, ::mforms::RadioButton*, mgr, f->_radio_impl, RadioButtonImpl, get_active);
      }
    };

  };
};

#endif // _WF_RADIOBUTTON_H_
