/* 
 * © 2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _WF_WIZARD_H_
#define _WF_WIZARD_H_

#include <mforms/mforms.h>

#include "mforms/wizard.h"
#include "wf_base.h"
#include "wf_mforms.h"

#include "wf_form.h"

using namespace std;

/**
 * Declaration of the wrapper of the mforms wizard form.
 */
namespace MySQL {
  namespace Forms {

    /**
     * Need this separate class to set protected members.
     */
    public ref class BufferedForm : public Form
    {
    public:
      BufferedForm();
    };

    /**
     * Wrapper for a native .NET wizard skeleton.
     */
    public ref class WizardImpl : public ObjectImpl
    {
    private:
      Form^ _main;
      FlowLayoutPanel^ _sidebar;
      Label^ _title;
      Button^ _extra_button;
      TableLayoutPanel^ _footer;
      FlowLayoutPanel^ _button_bar;
      Button^ _back_button;
      Button^ _next_button;
      Button^ _cancel_button;
      Panel^ _content; // This is where the actual wizard content is docked to.
      Image^ _sidebar_overlay;
    protected:
      static bool create(::mforms::Wizard *self);
      static void set_title(::mforms::Wizard *self, const string &title);
      static void run_modal(::mforms::Wizard *self);
      static void close(::mforms::Wizard *self);
      static void flush_events(::mforms::Wizard *self);
      static void set_content(::mforms::Wizard *self, ::mforms::View *view);
      static void set_heading(::mforms::Wizard *self, const string& heading);
      static void set_step_list(::mforms::Wizard *self, const vector<string>& steps);
      static void set_allow_cancel(::mforms::Wizard *self, bool flag);
      static void set_allow_back(::mforms::Wizard *self, bool flag);
      static void set_allow_next(::mforms::Wizard *self, bool flag);
      static void set_show_extra(::mforms::Wizard *self, bool flag);
      static void set_extra_caption(::mforms::Wizard *self, const string& caption);
      static void set_next_caption(::mforms::Wizard *self, const string& caption);

      static void sidebarPaint(Object^ sender, PaintEventArgs^ arguments);
      static void nextClick(Object^ sender, EventArgs^ arguments);
      static void backClick(Object^ sender, EventArgs^ arguments);
      static void cancelClick(Object^ sender, EventArgs^ arguments);
      static void extraClick(Object^ sender, EventArgs^ arguments);
      static void resize(Object^ sender, EventArgs^ arguments);
    public:
      WizardImpl(::mforms::Wizard *self);

      void set_title(const string &title);
      void run_modal();
      void close();
      void flush_events();
      void set_content(::mforms::View *view);
      void set_heading(const string & heading);
      void set_step_list(const vector<string>& steps);
      void set_allow_cancel(bool flag);
      void set_allow_back(bool flag);
      void set_allow_next(bool flag);
      void set_show_extra(bool flag);
      void set_extra_caption(const string& caption);
      void set_next_caption(const string& caption);

      static void init(Manager ^mgr)
      {
        ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

        DEF_CALLBACK1(bool, ::mforms::Wizard*, mgr, f->_wizard_impl, WizardImpl, create);
        DEF_CALLBACK2(void, ::mforms::Wizard*, const string&, mgr, f->_wizard_impl, WizardImpl, set_title);
        DEF_CALLBACK1(void, ::mforms::Wizard*, mgr, f->_wizard_impl, WizardImpl, run_modal);
        DEF_CALLBACK1(void, ::mforms::Wizard*, mgr, f->_wizard_impl, WizardImpl, close);
        DEF_CALLBACK1(void, ::mforms::Wizard*, mgr, f->_wizard_impl, WizardImpl, flush_events);
        DEF_CALLBACK2(void, ::mforms::Wizard*, ::mforms::View*, mgr, f->_wizard_impl, WizardImpl, set_content);
        DEF_CALLBACK2(void, ::mforms::Wizard*, const string&, mgr, f->_wizard_impl, WizardImpl, set_heading);
        DEF_CALLBACK2(void, ::mforms::Wizard*, const vector<string>&, mgr, f->_wizard_impl, WizardImpl, set_step_list);
        DEF_CALLBACK2(void, ::mforms::Wizard*, bool, mgr, f->_wizard_impl, WizardImpl, set_allow_cancel);
        DEF_CALLBACK2(void, ::mforms::Wizard*, bool, mgr, f->_wizard_impl, WizardImpl, set_allow_back);
        DEF_CALLBACK2(void, ::mforms::Wizard*, bool, mgr, f->_wizard_impl, WizardImpl, set_allow_next);
        DEF_CALLBACK2(void, ::mforms::Wizard*, bool, mgr, f->_wizard_impl, WizardImpl, set_show_extra);
        DEF_CALLBACK2(void, ::mforms::Wizard*, const string&, mgr, f->_wizard_impl, WizardImpl, set_extra_caption);
        DEF_CALLBACK2(void, ::mforms::Wizard*, const string&, mgr, f->_wizard_impl, WizardImpl, set_next_caption);
      }
    };
  }
}

#endif // _WF_WIZARD_H_