/* 
 * © 2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _GRT_DIFF_H
#define _GRT_DIFF_H

#include "grtpp.h"
#include "grtpp_util.h"

namespace grt
{
class ValueRef;
class BaseListRef;
class DictRef;
//class ObjectRef;
class DiffChange;


class GrtDiff
{
protected:
  const Omf* omf;
  virtual DiffChange *on_list(DiffChange *parent, const BaseListRef &source, const BaseListRef &target, const TSlotNormalizerSlot sqlDefinitionCmp);
  virtual DiffChange *on_dict(DiffChange *parent, const DictRef &source, const DictRef &target, const TSlotNormalizerSlot sqlDefinitionCmp);
  virtual DiffChange *on_object(DiffChange *parent, const ObjectRef &source, const ObjectRef &target,const TSlotNormalizerSlot sqlDefinitionCmp);

  virtual DiffChange *on_uncompatible(DiffChange *parent, const ValueRef &source, const ValueRef &target);

  std::string trim_zeros(const std::string& str)const;
  std::string fixDefalutString(const std::string& str)const;

  DiffChange *on_value(DiffChange *parent, const ValueRef &source, const ValueRef &target, const TSlotNormalizerSlot sqlDefinitionCmp);
public:
  GrtDiff() : omf(NULL) {};
  DiffChange *diff(const ValueRef &source, const ValueRef &target, const Omf* omf,const TSlotNormalizerSlot sqlDefinitionCmp);
  virtual ~GrtDiff() {}
};

}

#endif
