/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef _MYSQL_SQL_SCRIPT_SPLITTER_H_
#define _MYSQL_SQL_SCRIPT_SPLITTER_H_


#include <boost/shared_ptr.hpp>
#include <list>
#include <string>


namespace mysql_parser
{
class MyxStatementParser;
typedef struct charset_info_st CHARSET_INFO;
}
using namespace mysql_parser;


/** Splits given SQL script into separate statements.
 * 
 * @ingroup sqlparser
 */
class Mysql_sql_script_splitter
{
public:
  typedef boost::shared_ptr<Mysql_sql_script_splitter> Ref;
  static Ref create() { return Ref(new Mysql_sql_script_splitter()); }
  virtual ~Mysql_sql_script_splitter();
protected:
  Mysql_sql_script_splitter();

public:
  int process(const std::string &sql, std::list<std::string> &statements);

private:
  static int process_statement(const MyxStatementParser *splitter, const char *sql, void *userdata);
  CHARSET_INFO *_cs;
};


#endif // _MYSQL_SQL_SCRIPT_SPLITTER_H_
