/* 
 * (c) 2009-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __STOREDNOTEEDITOR_H__
#define __STOREDNOTEEDITOR_H__

#include "wb_editor_storednote.h"
#include "GrtTemplates.h"
#include "string_utilities.h"

#pragma make_public(::StoredNoteEditorBE)

#ifdef _MSC_VER
//#include  <vcclr.h> // .net interop helpers
using namespace MySQL::Grt;
using namespace System;
using namespace System::Runtime::InteropServices;
using namespace System::Collections::Generic;
#endif

namespace MySQL {
namespace Grt {

public ref class StoredNoteEditorBE : public BaseEditor
{
private:
  bool _is_script;
protected:
  StoredNoteEditorBE(::StoredNoteEditorBE *inn)
    : BaseEditor(inn)
  {}

public:
  StoredNoteEditorBE::StoredNoteEditorBE(MySQL::Grt::GrtManager^ grtm, MySQL::Grt::GrtValue^ arglist)
  : BaseEditor(
      new ::StoredNoteEditorBE(grtm->get_unmanaged_object(), 
      GrtStoredNoteRef::cast_from(grt::BaseListRef::cast_from(arglist->get_unmanaged_object()).get(0))
          )
      )
  {
    grt::ValueRef value= grt::BaseListRef::cast_from(arglist->get_unmanaged_object()).get(0);
    _is_script= grt::ObjectRef::cast_from(value).is_instance("db.Script");
  }

  ::StoredNoteEditorBE *get_unmanaged_object()
  { return static_cast<::StoredNoteEditorBE *>(inner); }

  void set_text(String ^text)
  {
    get_unmanaged_object()->set_text(NativeToCppString(text));
  }

  String^ get_text([Out] bool %isutf8)
  {
    bool tmp;
    String ^str;
    str= CppStringToNative(get_unmanaged_object()->get_text(tmp));
    isutf8= tmp;
    return str;
  }

  void set_name(String ^name)
  {
    get_unmanaged_object()->set_name(NativeToCppString(name));
  }

  String^ get_name()
  {
    return CppStringToNative(get_unmanaged_object()->get_name());
  }

  bool load_file(String ^name)
  {
    try
    {
      return get_unmanaged_object()->load_file(NativeToCppString(name));
    }
    catch (std::exception &exc)
    {
      show_exception(gcnew String(_("Load File")), CppStringToNative(exc.what()));
      return false;
    }
  }

  bool save_file(String ^name)
  {
    return get_unmanaged_object()->save_file(NativeToCppString(name));
  }

  bool is_sql_script()
  {
    return _is_script;
  }
};

} // namespace Grt
} // namespace MySQL

#endif // __STOREDNOTEEDITOR_H__