#ifndef _ADDON_PROC_H_
#define _ADDON_PROC_H_


#include "addon_repo.h"
#include "logger.h"


class Addon_proc
{
public:
  Addon_proc();
  virtual ~Addon_proc();

  PROPERTY(Logger *, log)
  PROPERTY(Addon_repo *, cached_addons)
  PROPERTY(File_dir, temp_dir)

  void execute();

protected:
  void ensure_valid_state();
  virtual void do_ensure_valid_state(std::string &err);

  virtual void before_execute() {}
  virtual void after_execute() {}
  virtual void do_execute() {}
  
  Logger *_log;
  Addon_repo *_cached_addons;
  File_dir _temp_dir;
};


#endif // _ADDON_PROC_H_
