#ifndef _FILE_DOWNLOADER_H_
#define _FILE_DOWNLOADER_H_


#include "file_downloader.h"
#include <curl/curl.h>
#include <sigc++/sigc++.h>
#include "util.h"


class File_downloader
{
public:
  static CURLcode global_init(long flags= CURL_GLOBAL_DEFAULT);
  static void global_cleanup();

  typedef sigc::slot<int, double, double> Progress_cb;

  File_downloader();
  ~File_downloader();

  bool download();
  void cancel_download();
  void disconnect_progress_cb();

  PROPERTY_RE(std::string, filepath, _file.path)
  PROPERTY_RE(std::string, log_filepath, _log.path)
  PROPERTY(std::string, url)
  PROPERTY(std::string, user_agent)

  PROPERTY(std::string, proxy_type)
  PROPERTY(std::string, proxy_server)
  PROPERTY(std::string, proxy_userpwd)

  PROPERTY(std::string, server_userpwd)

  PROPERTY(Progress_cb, progress_cb)

  bool cancelled() { return _cancelled; }

private:
  static int translate_proxy_type(const std::string &val);
  static int write_data(void *buffer, size_t size, size_t nmemb, void *data);
  friend int write_data(void *, size_t, size_t, void *);
  static int update_progress(void *clientp, double dltotal, double dlnow, double ultotal, double ulnow);
  static int process_debug_msg(CURL *curl, curl_infotype infotype, char *msg, size_t size, void *data);

  friend int update_progress(void *clientp, double dltotal, double dlnow, double ultotal, double ulnow);

  void add_log_message(const std::string &msg);

  File _log;
  File _file;
  std::string _url;
  std::string _user_agent;
  std::string _proxy_type;
  std::string _proxy_server;
  std::string _proxy_userpwd;
  std::string _server_userpwd;
  bool _cancelled;

  Progress_cb _progress_cb;
};


#endif // _FILE_DOWNLOADER_H_
