#include "stdafx.h"
#include "wb_addon_manager.h"


using namespace grt;


Wb_addon_manager::Wb_addon_manager()
:
_grtm(NULL),
_log(&_def_log)
{
}


void Wb_addon_manager::grtm(bec::GRTManager *grtm)
{
  try
  {
    _grtm= grtm;

    _log->grtm(_grtm);
    log(_log);

    Logger::Scope_disabler lsd(_log);

    _base_dir= _grtm->get_basedir();
    _data_dir= _grtm->get_data_file_path(std::string());
    _user_data_dir= _grtm->get_user_datadir();

    _temp_dir= _grtm->get_tmp_dir() + "/addon_manager";
    _temp_dir.ensure_exists();

    load_cached_addons_repo();
    //_cached_addons.purge();//!
    load_installed_addons_repo();

    DictRef options= DictRef::cast_from(_grtm->get_grt()->get("/wb/options/options"));

    _directory_page_url= options.get_string("AddonDirectoryPageURL");

    _fd.proxy_type(options.get_string("ProxyType"));
    _fd.proxy_server(options.get_string("ProxyServer"));
    _fd.proxy_userpwd(options.get_string("ProxyUserPwd"));

    _fd.progress_cb(sigc::mem_fun(_log, &Grt_logger::process_download_progress));

    // active version
    {
      std::ostringstream version;
      {
        GrtVersionRef ver= GrtVersionRef::cast_from(grtm->get_grt()->get("/wb/info/version"));
        version << ver->majorNumber() << "." << ver->minorNumber() << "." << ver->releaseNumber();
      }
      _active_version= version.str();
    }

    _fd.user_agent("mysql_workbench-agent/" + _active_version);

    // base_url, _url_suffix
    {
      std::string edition= _active_config.substr(0, _active_config.find(' '));
      std::string rel_type= _active_config.substr(_active_config.find(' ') + 1);

      _url_base= options.get_string("AddonBaseURL");
      _url_suffix=
        + "&config=" + _active_config
        + "&version=" + _active_version
        + "&revision=" + _active_revision
        + "&edition=" + edition
        + "&rel_type=" + rel_type
#ifdef _WIN32
        + "&os=win32"
#endif
        ;

      // whitespaces in URL are not allowed, replace them with underscores
      for (std::string::iterator i= _url_suffix.begin(), i_end= _url_suffix.end(); i != i_end; ++i)
        if (' ' == *i)
          *i= '_';
    }
  }
  catch(std::exception &e)
  {
    _log->push_err(e.what());
    throw;
  }
}


void Wb_addon_manager::load_manifest(const std::string &guid, const std::string &min_ver, const std::string &max_ver)
{
  Addon_manager::load_manifest(guid, min_ver, max_ver);
}


void Wb_addon_manager::load_manifest_from_url(const std::string &url, std::string &guid, std::string &version)
{
  Addon_manager::load_manifest_from_url(url, guid, version);
}


void Wb_addon_manager::start_download(const std::string &guid, const std::string &version)
{
  bec::GRTTask *task= new bec::GRTTask("Download addon(s)", 
    _grtm->get_dispatcher(),
    sigc::bind<std::string, std::string>(
      sigc::mem_fun(this, &Wb_addon_manager::download),
      guid, version));

  task->signal_message().connect(sigc::mem_fun(_log, &Grt_logger::process_task_msg));
  task->signal_failed().connect(sigc::mem_fun(_log, &Grt_logger::process_task_fail));
  task->signal_finished().connect(sigc::mem_fun(_log, &Grt_logger::process_task_finish));

  _grtm->get_dispatcher()->add_task(task);
}


ValueRef Wb_addon_manager::download(grt::GRT *grt, const std::string &guid, const std::string &version)
{
  Grt_logger::Scope_callbacks_disabler lscbd(_log);
  Addon_manager::download(guid, version);
  return grt::StringRef("Addon package(s) were downloaded.");
}


void Wb_addon_manager::cancel_download()
{
  _fd.cancel_download();
}


void Wb_addon_manager::install(const std::string &guid, const std::string &version)
{
  Addon_manager::install(guid, version);
}


void Wb_addon_manager::uninstall(const std::string &guid)
{
  Addon_manager::uninstall(guid);
}


void Wb_addon_manager::get_installed_addons(std::list<std::string> &guids, std::list<std::string> &names)
{
  Addon_manager::get_installed_addons(guids, names);
}
