#include "stdafx.h"

#include "wb_updater_wr.h"

namespace MySQL {
namespace GUI {
namespace Workbench {
namespace Plugins {
namespace Wb {


using namespace System;
using namespace System::Runtime::InteropServices;
using namespace System::Collections::Generic;
using namespace MySQL::Grt;
using namespace System::Reflection;
using namespace System::Windows::Forms;

Wb_updater::Wb_updater(MySQL::Grt::GrtManager ^grtm)
  : _inner(new ::Wb_updater(grtm->get_unmanaged_object()))
{
  Assembly ^assembly = Assembly::GetEntryAssembly();
  String ^value = gcnew String("");

  // configuration
  {
    array<Object^> ^attributes = assembly->GetCustomAttributes(AssemblyConfigurationAttribute::typeid, false);
    if (attributes->Length > 0)
    {
      value = (safe_cast<AssemblyConfigurationAttribute^>(attributes[0]))->Configuration;
      _inner->active_config(NativeToCppString(value));
    }
  }

  // version + revision
  {
    Version ^version = gcnew Version(Application::ProductVersion);
    value = String::Format("{0}.{1}.{2}",
      version->Major, version->Minor, version->Build);
    _inner->active_version(NativeToCppString(value));

    value = String::Format("{0}", version->MinorRevision);
    _inner->active_revision(NativeToCppString(value));
  }
}


Wb_updater::~Wb_updater()
{
  if (_inner)
    delete _inner;
}


String ^ Wb_updater::current_version_details()
{
  std::string details= _inner->active_config() + " - v" + _inner->active_version();
  return CppStringToNative(details);
}


bool Wb_updater::fetch_release_info()
{
  return _inner->fetch_release_info();
}


String ^ Wb_updater::working_dir()
{
  String ^res = CppStringToNative(_inner->working_dir().path());
  return res;
}


void Wb_updater::proxy_type(String ^proxy_type)
{
  _inner->proxy_type(NativeToCppString(proxy_type));
}


void Wb_updater::proxy_server(String ^proxy_server)
{
  _inner->proxy_server(NativeToCppString(proxy_server));
}


void Wb_updater::proxy_userpwd(String ^proxy_userpwd)
{
  _inner->proxy_userpwd(NativeToCppString(proxy_userpwd));
}


void Wb_updater::server_userpwd(String ^server_userpwd)
{
  _inner->server_userpwd(NativeToCppString(server_userpwd));
}


List<String^> ^ Wb_updater::rel_names()
{
  std::list<std::string> rel_names_;
  _inner->get_rel_names(rel_names_);
  return CppStringListToNative2(rel_names_);
}


List<String^> ^ Wb_updater::download_mirrors(int rel_index)
{
  std::list<std::string> mirrors_;
  _inner->get_mirrors(rel_index, mirrors_);
  return CppStringListToNative2(mirrors_);
}


String ^ Wb_updater::result_filepath()
{
  String ^res = CppStringToNative(_inner->result_filepath());
  res = System::IO::Path::GetFullPath(res);
  return res;
}


bool Wb_updater::install()
{
  try
  {
    System::Diagnostics::Process ^proc= gcnew System::Diagnostics::Process;
    proc->StartInfo->FileName = "msiexec.exe";
    String ^fn= result_filepath();
    if (0 == fn->Length)
      return false;
    proc->StartInfo->Arguments = String::Concat("/i \"", fn, "\"");
    return proc->Start();
  }
  catch (...)
  {
    return false;
  }
  //!return _inner->install();
}


void Wb_updater::start_download(int rel_index, int mirror_index)
{
  return _inner->start_download(rel_index, mirror_index);
}


void Wb_updater::task_msg_cb(Task_msg_cb::ManagedDelegate ^deleg)
{
  _task_msg_cb= gcnew Task_msg_cb(deleg);
  _inner->task_msg_cb(_task_msg_cb->get_slot());
}


void Wb_updater::task_progress_cb(Task_progress_cb::ManagedDelegate ^deleg)
{
  _task_progress_cb= gcnew Task_progress_cb(deleg);
  _inner->task_progress_cb(_task_progress_cb->get_slot());
}


void Wb_updater::task_fail_cb(Task_fail_cb::ManagedDelegate ^deleg)
{
  _task_fail_cb= gcnew Task_fail_cb(deleg);
  _inner->task_fail_cb(_task_fail_cb->get_slot());
}


void Wb_updater::task_finish_cb(Task_finish_cb::ManagedDelegate ^deleg)
{
  _task_finish_cb= gcnew Task_finish_cb(deleg);
  _inner->task_finish_cb(_task_finish_cb->get_slot());
}


};  // namespace Wb
};  // namespace Plugins
};  // namespace Workbench
};  // namespace GUI
};  // namespace MySQL
