#ifndef __WB_UPDATER_WR_H__
#define __WB_UPDATER_WR_H__

#include "wb_updater.h"
#include "GrtTemplates.h"
#include "SigCSlot.h"


namespace MySQL {
namespace GUI {
namespace Workbench {
namespace Plugins {
namespace Wb {


using namespace System;
using namespace System::Runtime::InteropServices;
using namespace System::Collections::Generic;
using namespace MySQL::Grt;


public ref class Wb_updater
{
private:
  ::Wb_updater *_inner;

public:
  Wb_updater(MySQL::Grt::GrtManager ^grtm);
  ~Wb_updater();

  String ^ current_version_details();
  bool fetch_release_info();
  List<String^> ^ rel_names();
  List<String^> ^ download_mirrors(int rel_index);
  String ^ working_dir();
  void proxy_type(String ^proxy_type);
  void proxy_server(String ^proxy_server);
  void proxy_userpwd(String ^proxy_userpwd);
  void server_userpwd(String ^server_userpwd);
  int rel_authorization(int rel_index) { return _inner->rel_authorization(rel_index); }
  void start_download(int rel_index, int mirror_index);
  void cancel_download() { _inner->cancel_download(); }
  String ^ result_filepath();
  bool install();

  typedef DelegateSlot2<int, int,
    int, int,
    std::string, String^> Task_msg_cb;
  void task_msg_cb(Task_msg_cb::ManagedDelegate ^cb);

  typedef DelegateSlot2<int, int,
    float, float,
    std::string, String^> Task_progress_cb;
  void task_progress_cb(Task_progress_cb::ManagedDelegate ^cb);

  typedef DelegateSlot1<int, int,
    std::string, String^> Task_fail_cb;
  void task_fail_cb(Task_fail_cb::ManagedDelegate ^cb);

  typedef DelegateSlot0<int, int> Task_finish_cb;
  void task_finish_cb(Task_finish_cb::ManagedDelegate ^cb);  

protected:
  Task_msg_cb ^_task_msg_cb;
  Task_progress_cb ^_task_progress_cb;
  Task_fail_cb ^_task_fail_cb;
  Task_finish_cb ^_task_finish_cb;
};


};  // namespace Wb
};  // namespace Plugins
};  // namespace Workbench
};  // namespace GUI
};  // namespace MySQL

#endif // __WB_UPDATER_WR_H__