/* 
 * Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _DB_SQL_EDITOR_SNIPPETSBE_H_
#define _DB_SQL_EDITOR_SNIPPETSBE_H_


#include "workbench/wb_backend_public_interface.h"
#include "ui_form.h"
#include "grt/tree_model.h"
#include "workbench/wb_command_ui.h"
#include "sqlide/wb_context_sqlide.h"

class MYSQLWBBACKEND_PUBLIC_FUNC DbSqlEditorSnippets : public bec::ListModel
{
public:
  enum Column
  {
    Letter,
    Description,
    Script
  };

  static void setup(wb::WBContextSQLIDE *sqlide, const std::string &path);
  static DbSqlEditorSnippets *get_instance();

  void load();
  void save();

  std::vector<std::string> get_category_list();
  void select_category(const std::string &category);
  std::string selected_category() { return _selected_category; }

  virtual int count();
  virtual bool get_field(const bec::NodeId &node, int column, std::string &value);
  virtual bool set_field(const bec::NodeId &node, int column, const std::string &value);
  virtual void refresh() {}
  
  virtual bool activate_node(const bec::NodeId &node);

  bec::ToolbarItemList get_toolbar_items();
  bool activate_toolbar_item(const bec::NodeId &selected, const std::string &name);

  virtual bec::MenuItemList get_popup_items_for_nodes(const std::vector<bec::NodeId> &nodes);
  virtual bool activate_popup_item_for_nodes(const std::string &name, const std::vector<bec::NodeId> &nodes);
  
  virtual bool can_delete_node(const bec::NodeId &node);
  virtual bool delete_node(const bec::NodeId &node);

protected:
  DbSqlEditorSnippets(wb::WBContextSQLIDE *sqlide, const std::string &path);
  wb::WBContextSQLIDE *_sqlide;
  std::string _path;
  std::string _selected_category;

  std::vector<std::pair<std::string, std::string> > _entries;
public:
  void add_snippet(const std::string &name, const std::string &snippet);
};


#endif /* _DB_SQL_EDITOR_SNIPPETSBE_H_ */
