#include "stdafx.h"
#include "test.h"
#include <grtpp.h>
#include "grt_test_utility.h"

#include "workbench/wb_overview.h"
#include "grts/structs.workbench.h"
#include "grts/structs.workbench.logical.h"
#include "grts/structs.workbench.physical.h"


using namespace grt;
using namespace wb;
using namespace bec;

BEGIN_TEST_DATA_CLASS(wb_overview)
public:
  WBTester wb;

TEST_DATA_CONSTRUCTOR(wb_overview)
{
}

END_TEST_DATA_CLASS


TEST_MODULE(wb_overview, "wb overview");

TEST_FUNCTION(1) 
{
  bool flag= wb.wb->open_document("data/workbench/test_model1.mwb");
  ensure("open_document", flag);
}


TEST_FUNCTION(2)
{
  std::vector<int> columns;

  columns.push_back(wb::OverviewBE::Label);
  columns.push_back(wb::OverviewBE::NodeType);
  columns.push_back(wb::OverviewBE::Expanded);
  columns.push_back(wb::OverviewBE::Height);
  columns.push_back(wb::OverviewBE::DisplayMode);
  dump_tree_model("output/overview_test2.txt", wb.wb->get_ui()->get_physical_overview(), columns);

  ensure_files_equal("initial overview state ", "output/overview_test2.txt", "data/be/overview_test2.txt");
}


END_TESTS
