/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _WB_COMMAND_UI_H_
#define _WB_COMMAND_UI_H_


#include "wb_context.h"

namespace wb
{

  enum CommandItemValidationState
  {
    ItemDisabled = 0,
    ItemEnabled = 1,
    ItemEnabledAndChecked = 2
  };
 
  struct ParsedCommand;

  // Manager menus and toolbars.
  class MYSQLWBBACKEND_PUBLIC_FUNC CommandUI
  {
    friend class WBContextUI;
    
    struct BuiltinCommand
    {
      sigc::slot<void> execute;
      sigc::slot<CommandItemValidationState> validate;
    };

    WBContext *_wb;
    // dynamic UI stuff
    std::vector<app_MenuItemRef> _main_menus;
    std::map<std::string, app_MenuItemRef> _menu_items;
    app_ToolbarRef _default_toolbar;

    grt::ListRef<app_ShortcutItem> _shortcuts;

    std::map<std::string, BuiltinCommand> _builtin_commands;

    CommandItemValidationState validate_command_item(const app_CommandItemRef &item, const ParsedCommand &cmd);
    void update_item_state(const app_CommandItemRef &item, const ParsedCommand &cmd, bec::MenuItem &menu_item);
    void update_item_state(const app_ToolbarItemRef &item, const ParsedCommand &cmd, bec::ToolbarItem &tb_item);
    std::string get_command_item_caption(const app_CommandItemRef &item);

    void append_menu_items(const grt::ListRef<app_MenuItem> &plist, const std::string &context,
      std::vector<bec::MenuItem> *items);
    void append_toolbar_items(const grt::ListRef<app_ToolbarItem> &plist, const std::string &context,
      std::vector<bec::ToolbarItem> *items);
    void append_shortcut_items(const grt::ListRef<app_ShortcutItem> &plist, const std::string &context,
      std::vector<WBShortcut> *items);

    void add_builtin_form_command(const std::string &name, 
      const sigc::slot<void,bec::UIForm*> &slot, 
      const sigc::slot<CommandItemValidationState,bec::UIForm*> &validate, 
      bool main_form);
    bool is_builtin_command(const std::string &name);
    bool execute_builtin_command(const std::string &name);
    CommandItemValidationState validate_builtin_command(const std::string &name);

    CommandItemValidationState validate_active_form_command(const sigc::slot<CommandItemValidationState,bec::UIForm*> &slot, bool main_form);
    void execute_active_form_command(const sigc::slot<void,bec::UIForm*> &slot, bool main_form);

    bec::MenuItemList get_menu_items(const std::string &menu, const std::string &context);
  public:
    CommandUI(WBContext *wb);
    
    void load_data();

    void activate_command(const std::string &command);
    bool activate_command(const std::string &command, bec::ArgumentPool argpool);
    
    std::vector<WBShortcut> get_shortcuts_for_context(const std::string &context);

    void add_frontend_commands(const std::list<std::string> &commands);
    void add_builtin_toggle_command(const std::string &name, 
                             const sigc::slot<void> &slot,
                             const sigc::slot<CommandItemValidationState> &validate= sigc::slot<CommandItemValidationState>());
    void add_builtin_command(const std::string &name, 
                             const sigc::slot<void> &slot,
                             const sigc::slot<bool> &validate= sigc::slot<bool>());
    
    bec::MenuItemList get_main_menus();
    bec::MenuItemList get_menu_items(const std::string &menu);
    bec::MenuItemList get_edit_menu_items(bool textbox_focused);
    bec::ToolbarItemList get_toolbar_items(const std::string &toolbar, const std::string &context = std::string());    

    std::vector<std::string> get_dropdown_items(const std::string &name, const std::string &option, std::string &selected);
    void select_dropdown_item(const std::string &name, const std::string &option, const std::string &item);
    void toggle_checkbox_item(const std::string &name, const std::string &option, bool state);
  };
};


#endif /* _WB_COMMAND_UI_H_ */
