/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _GRT_MODULES_LIST_H_
#define _GRT_MODULES_LIST_H_

#include <grtpp.h>
#include "tree_model.h"

namespace bec {

class WBPUBLICBACKEND_PUBLIC_FUNC ModulesTreeBE : public TreeModel
{
public:
  enum ModulesTreeColumns {
    Name
  };
  
  ModulesTreeBE(grt::GRT *grt);

  virtual int count_children(const NodeId &parent);
  virtual NodeId get_child(const NodeId &parent, int index);

  virtual bool get_field(const NodeId &node, int column, std::string &value);
  virtual IconId get_field_icon(const NodeId &node, int column, IconSize size);

  virtual std::string get_field_description(const NodeId &node, int column);
  
  virtual grt::Type get_field_type(const NodeId &node, int column);

  virtual void refresh();
  
private:
  grt::GRT *_grt;
  int _module_count;
};

};

#endif /* _GRT_MODULES_LIST_H_ */
