/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _CHARSET_LIST_H_
#define _CHARSET_LIST_H_

#include <grtpp.h>
#include "grt/tree_model.h"


namespace bec {
  
  class CharsetList : public ListModel {
  public:
    CharsetList(grt::GRT *grt, const std::string &path);

    enum CharsetListColumns {
      Name
    };

    virtual int count_children(const NodeId &parent);

    virtual bool get_field(const NodeId &node, int column, std::string &value);

    virtual std::string get_field_description(const NodeId &node, int column);

    void picked_charset(const NodeId &node);

  protected:
    grt::GRT *_grt;
    
    std::list<int> _recently_used;

    std::string _charset_list_path;

  };
  
};


#endif /* _CHARSET_LIST_H_ */
