/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef _SQL_SYNTAX_CHECK_H_
#define _SQL_SYNTAX_CHECK_H_


#include "wbpublic_public_interface.h"
#include "sql_parser_base.h"


/**
 * Defines interface to check syntax of provided SQL statement/script.
 * 
 * @ingroup sqlparser
 */
class WBPUBLICBACKEND_PUBLIC_FUNC Sql_syntax_check : virtual public Sql_parser_base
{
public:
  typedef boost::shared_ptr<Sql_syntax_check> Ref;
protected:
  Sql_syntax_check(grt::GRT *grt) : Sql_parser_base(grt), _object_type(ot_none) {}

public:
  enum Statement_type { sql_unknown, sql_empty, sql_create, sql_alter, sql_drop, sql_insert, sql_delete, sql_update, sql_select, sql_describe, sql_show, sql_use, sql_load, sql_edit };
  virtual Statement_type determine_statement_type(const std::string &sql)= 0;

public:
  virtual bool parse_edit_statement(const std::string &sql, std::string &schema_name, std::string &table_name, std::string &statement_tail)= 0;

public:
  enum ObjectType { ot_none, ot_trigger, ot_view, ot_routine };
  void only_object_type_of(ObjectType ot) { _object_type= ot; }
protected:
  ObjectType _object_type;

public:
  virtual int check_sql(const std::string &sql)= 0;
  virtual int check_trigger(const std::string &sql)= 0;
  virtual int check_view(const std::string &sql)= 0;
  virtual int check_routine(const std::string &sql)= 0;
};


#endif // _SQL_SYNTAX_CHECK_H_
