/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _CHECKBOX_LIST_CONTROL_H_
#define _CHECKBOX_LIST_CONTROL_H_

#include "mforms/mforms.h"
#include "grtpp.h"

#include "wbpublic_public_interface.h"

class WBPUBLICBACKEND_PUBLIC_FUNC StringCheckBoxList : public mforms::ScrollPanel
{
  std::vector<mforms::CheckBox*> _items;
  mforms::Box _box;
  sigc::signal<void> _signal_changed;
  
  
  void toggled();
  
public:
  StringCheckBoxList();
  
  void set_strings(const std::vector<std::string> &strings);
  void set_strings(const grt::StringListRef &strings);

  std::vector<std::string> get_selection();
  bool has_selection();
  
  void set_selected(const std::string &name, bool flag);
  
  sigc::signal<void> signal_changed() { return _signal_changed; }
};


#endif /* _CHECKBOX_LIST_CONTROL_H_ */
