/* 
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA 02110-1301  USA
 */

#include "stdafx.h"

#include <grts/structs.db.query.h>

#include <grtpp_util.h>
#include "sqlide/sql_editor_be.h"
#include "db_query_Editor.h"
#include "db_query_QueryBuffer.h"

//================================================================================
// db_query_QueryBuffer

/*
db_query_QueryBufferRef WBPUBLICBACKEND_PUBLIC_FUNC grtwrap_sqleditor(db_query_EditorRef owner, Sql_editor::Ref editor)
{
  db_query_QueryBufferRef object(owner.get_grt());
  
  db_query_QueryBuffer::ImplData *data= new db_query_QueryBuffer::ImplData(object, editor);
  
  object->owner(owner);
  
  object->set_data(data);
  
  return object;
}*/



void db_query_QueryBuffer::init()
{
  // _data init is delayed and done by grtwrap_sqleditor
}

db_query_QueryBuffer::~db_query_QueryBuffer()
{
  delete _data;
}


void db_query_QueryBuffer::set_data(ImplData *data)
{
  _data= data;
}

grt::StringRef db_query_QueryBuffer::script() const
{
  Sql_editor::Ref editor(_data->editor.lock());
  return grt::StringRef(editor->sql());
}

grt::StringRef db_query_QueryBuffer::selectedText() const
{
  Sql_editor::Ref editor(_data->editor.lock());
  return grt::StringRef(editor->selected_text());
}

void db_query_QueryBuffer::selectionEnd(const grt::IntegerRef &value)
{
  Sql_editor::Ref editor(_data->editor.lock());
  int start, end;
  if (editor->selected_range(start, end))
    editor->change_selected_range_slot(start, *value);
}

void db_query_QueryBuffer::selectionStart(const grt::IntegerRef &value)
{
  Sql_editor::Ref editor(_data->editor.lock());
  int start, end;
  if (editor->selected_range(start, end))
    editor->change_selected_range_slot(*value, end);
}

grt::IntegerRef db_query_QueryBuffer::selectionEnd() const
{
  Sql_editor::Ref editor(_data->editor.lock());
  int start, end;
  if (editor->selected_range(start, end))
    return grt::IntegerRef(end);
  return grt::IntegerRef(0);
}

grt::IntegerRef db_query_QueryBuffer::selectionStart() const
{
  Sql_editor::Ref editor(_data->editor.lock());
  int start, end;
  if (editor->selected_range(start, end))
    return grt::IntegerRef(start);
  return grt::IntegerRef(0);  
}


grt::IntegerRef db_query_QueryBuffer::replaceContents(const std::string &text)
{
  Sql_editor::Ref editor(_data->editor.lock());
  editor->is_refresh_enabled(true);
  editor->sql(text);
  db_query_EditorRef::cast_from(owner())->get_data()->refresh_editor(editor);
  
  return grt::IntegerRef(0);
}


grt::IntegerRef db_query_QueryBuffer::replaceSelection(const std::string &text)
{
  Sql_editor::Ref editor(_data->editor.lock());
  editor->replace_selected_text_slot(text);
  return grt::IntegerRef(0);
}





