/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef _SQLIDE_GENERICS_PRIVATE_H_
#define _SQLIDE_GENERICS_PRIVATE_H_


#include "wbpublic_public_interface.h"
#include <sqlite/database_exception.hpp>
#include <sqlite/variant.hpp>
#include <sqlite/query.hpp>
#include <sqlite/execute.hpp>
#include <sigc++/sigc++.h>
#include <ctime>


namespace sqlide
{

using namespace sqlite;

class WBPUBLICBACKEND_PUBLIC_FUNC BindSqlCommandVar : public boost::static_visitor<void>
{
public:
  BindSqlCommandVar() : _sql_command(NULL) {}
  BindSqlCommandVar(sqlite::command *sql_command) : _sql_command(sql_command) {}
  void sql_command(sqlite::command *sql_command) { _sql_command= sql_command; }
protected:
  sqlite::command *_sql_command;

public:
  result_type operator()(const long double &v) const { (*_sql_command) % (double)v; }
  result_type operator()(const int &v) const { (*_sql_command) % v; }
  result_type operator()(const boost::int64_t &v) const { (*_sql_command) % v; }
  result_type operator()(const std::string &v) const { (*_sql_command) % v; }
  result_type operator()(const Null &v) const { (*_sql_command) % sqlite::nil; }
  result_type operator()(const Unknown &v) const { (*_sql_command) % sqlite::nil; }
  result_type operator()(const BlobRef &v) const
  {
    if (v->empty())
      (*_sql_command) % sqlite::nil;
    else
      (*_sql_command) % *v;
  }

  template<typename T>
  result_type operator()(const T &v) const
  {
    throw std::runtime_error(std::string("BindSqlCommandVar: not implemented: ")+typeid(T).name());
  }
};


} // namespace sqlide


#endif /* _SQLIDE_GENERICS_H_ */
