/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _BADGE_FIGURE_H_
#define _BADGE_FIGURE_H_

#include "mdc.h"

#include <algorithm>

#include "wbpublic_public_interface.h"


class WBPUBLICBACKEND_PUBLIC_FUNC BadgeFigure : public mdc::Figure
{
  mdc::FontSpec _font;
  std::string _badge_id;
  std::string _text;
  mdc::Color _fill_color2;
  mdc::Color _text_color;
  cairo_pattern_t *_gradient;
  mdc::Size _text_size;
  
  virtual mdc::Size calc_min_size();
public:
  BadgeFigure(mdc::Layer *layer);
  virtual ~BadgeFigure();
  virtual void draw_contents(mdc::CairoCtx *cr);
  
  void set_badge_id(const std::string &bid);
  std::string badge_id() const { return _badge_id; }
  
  void set_text(const std::string &text);
  void set_gradient_from_color(const mdc::Color &color);
  void set_fill_color2(const mdc::Color &color);
  void set_text_color(const mdc::Color &color);
  
  sigc::connection updater_connection;
};


#endif
