/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __IMAGE_FIGURE_H__
#define __IMAGE_FIGURE_H__

#include "figure_common.h"
#include "wbpublic_public_interface.h"


namespace wbfig {

  class WBPUBLICBACKEND_PUBLIC_FUNC Image : public BaseFigure
  {
    typedef BaseFigure super;
    
    mdc::ImageFigure _image;

    bool _keep_aspect_ratio;

    virtual bool on_click(mdc::CanvasItem *target, const mdc::Point &point, mdc::MouseButton button, mdc::EventState state);
    
  public:
    Image(mdc::Layer *layer, FigureEventHub *hub, const model_ObjectRef &self);

    void keep_aspect_ratio(bool flag);
    double get_aspect_ratio();

    void set_image(cairo_surface_t *image);

    bool set_image(const std::string &filename);
    
    cairo_surface_t *get_image();

    virtual void set_allow_manual_resizing(bool flag);
  };  
  
};

#endif

