/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _MODEL_CONNECTION_IMPL_H_
#define _MODEL_CONNECTION_IMPL_H_

#include <mdc.h>
#include <grtpp.h>

#include "grts/structs.model.h"

#include "wbpublic_public_interface.h"

#include "model_object_impl.h"

#include "figure_common.h"
#include "connection_figure.h"


class WBPUBLICBACKEND_PUBLIC_FUNC model_Connection::ImplData : public model_Object::ImplData
{
  typedef model_Object::ImplData super;

protected:
  wbfig::Connection *_line;
  wbfig::CaptionFigure *_above_caption;
  mdc::Point _above_offset;
  wbfig::CaptionFigure *_below_caption;
  mdc::Point _below_offset;
  wbfig::CaptionFigure *_start_caption;
  mdc::Point _start_offset;
  wbfig::CaptionFigure *_end_caption;
  mdc::Point _end_offset;
  
  mdc::FontSpec _caption_font;

  sigc::connection _object_realized;
    
  bool _destroying;
  
  ImplData(model_Connection *owner);

  void member_changed(const std::string &name, const grt::ValueRef &ovalue);
  
  void layout_changed();
  
  void update_above_caption_pos();
  void update_below_caption_pos();
  
  void update_start_caption_pos();
  void update_end_caption_pos();
  
  virtual void caption_bounds_changed(const mdc::Rect &obounds, mdc::TextFigure *figure);
  
  void object_realized(const model_ObjectRef &object);

public:
  mdc::CanvasView *get_canvas_view() const;
  virtual bool is_realizable();
  void finish_realize();
  
  void set_above_caption(const std::string &text);
  void set_below_caption(const std::string &text);
  
  void set_start_caption(const std::string &text);
  void set_end_caption(const std::string &text);
    
public:  
  virtual mdc::CanvasItem *get_canvas_item() const { return _line; }
  virtual mdc::CanvasItem *get_start_canvas_item();
  virtual mdc::CanvasItem *get_end_canvas_item();
  
  virtual void unrealize();
  
private:
  model_Connection *self() const { return (model_Connection*)_self; }
};


#endif // _MODEL_CONNECTION_IMPL_H_
