/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _MODEL_FIGURE_IMPL_H_
#define _MODEL_FIGURE_IMPL_H_

#include <mdc.h>
#include <grtpp.h>

#ifdef _WIN32
#include <hash_map>
#define hash_map stdext::hash_map
#else
#include <ext/hash_map>
#define hash_map __gnu_cxx::hash_map
#endif

#include "grts/structs.model.h"

#include "wbpublic_public_interface.h"

#include "model_object_impl.h"

#include "figure_common.h"

#include "badge_figure.h"

#ifdef __GNUC__
namespace __gnu_cxx
{
  using std::size_t;

  template<>
    struct hash<grt::internal::Object*>
    {
      size_t
      operator()(grt::internal::Object* __p) const
      { return (intptr_t)__p; }
    };
};
#endif

namespace bec {
  class UndoAction;
};


class WBPUBLICBACKEND_PUBLIC_FUNC model_Figure::ImplData : public model_Object::ImplData
{
  typedef BridgeBase super;

  friend class model_Diagram::ImplData;

protected:
  std::list<BadgeFigure*> _badges;
  
  bool _resizable;
  bool _connected_update_options;
  bool _realizing;
  
  ImplData(model_Figure *owner);

  virtual void update_options(const std::string &key);
  
  void finish_realize();

  void member_changed(const std::string &member, const grt::ValueRef &ovalue);
  
  void figure_resized(const mdc::Rect &rect);
  void figure_bounds_changed(const mdc::Rect &rect);
  
  virtual bool is_realizable();
  
  void relayout_badges();
  
public:
  mdc::CanvasView* get_canvas_view() const;
  
  void set_layer(const model_LayerRef &layer);
  
  void add_badge(BadgeFigure *badge);
  void remove_badge(BadgeFigure *badge);
  BadgeFigure *get_badge_with_id(const std::string &badge_id);
  
public:    
  virtual void render_mini(mdc::CairoCtx *cr);
  virtual void unrealize();
  
  virtual void highlight(const mdc::Color *color= 0);
  virtual void unhighlight();  
  
private:
  model_Figure *self() const { return (model_Figure*)_self; }
};


#endif // _MODEl_FIGURE_IMPL_H_
