/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _MODEL_OBJECT_IMPL_H_
#define _MODEL_OBJECT_IMPL_H_

#include <mdc.h>
#include <grtpp.h>

#include "grts/structs.model.h"

#include "base_bridge.h"

#include "model_model_impl.h"


class WBPUBLICBACKEND_PUBLIC_FUNC model_Object::ImplData : public BridgeBase
{
protected:
  model_Object *_self;
  bool _in_view;


  ImplData(model_Object *object) : _self(object), _in_view(false) {}

  virtual GrtObject *get_object() { return _self; }

  void notify_realized();

public:
  virtual mdc::CanvasItem *get_canvas_item() const= 0;
  virtual void highlight(const mdc::Color *color= 0);
  virtual void unhighlight();
  
  virtual void set_in_view(bool flag);
  virtual bool in_view() { return _in_view; }

  virtual bool try_realize();

  virtual bool is_realizable()= 0;
  virtual bool realize()= 0;
  virtual void unrealize()= 0;
};

#endif /* _MODEL_OBJECT_IMPL_H_ */
