/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef __RECORDSET_WR_H__
#define __RECORDSET_WR_H__


#include "var_grid_model_wr.h"
#include "sqlide/recordset_be.h"
#include "GrtThreadedTask.h" // reference in stdafx.h is not enough because stdafx.h has subdir only effect


namespace MySQL {
namespace Grt {
namespace Db {


using namespace System;
using namespace System::Runtime::InteropServices;
using namespace System::Collections::Generic;


ref class Recordset_data_storage;


public ref class Recordset : public MySQL::Grt::VarGridModel
{
public:
  typedef ManagedRef<::Recordset> ^ Ref;
  Recordset(Ref ref);
  Recordset(IntPtr nref_ptr);
  Ref ref() { return _ref; }
  IntPtr ref_intptr() { return ~_ref; }
private:
  Ref _ref;
private:
  ~Recordset();

public:
  MySQL::Grt::ActionList ^action_list;

public:
  long long key() { return _ref->key(); }
  String ^ caption() { return CppStringToNative(_ref->caption()); }
  void caption(String ^value) { _ref->caption(NativeToCppString(value)); }
  bool can_close() { return _ref->can_close(); }
  bool close() { return _ref->close(); }
  bool pinned() { return _ref->pinned(); }
  void pinned(bool value) { _ref->pinned(value); }

  String ^ status_text() { return CppStringToNative(_ref->status_text()); }

  int row_count() { return _ref->row_count(); }

  void pending_changes(int %upd_count, int %ins_count, int %del_count);
  bool has_pending_changes() { return _ref->has_pending_changes(); }
  void apply_changes() { _ref->apply_changes(); }
  void rollback() { _ref->rollback(); }

  void limit_rows(bool value) { _ref->limit_rows(value); }
  bool limit_rows() { return _ref->limit_rows(); }
  bool limit_rows_applicable() { return _ref->limit_rows_applicable(); }
  int limit_rows_count() { return _ref->limit_rows_count(); }

  int real_row_count() { return (int)_ref->real_row_count(); }

  void sort_by(int column, int direction, bool retaining) { _ref->sort_by((::ColumnId) column, direction, retaining); }

  bool delete_nodes(List<NodeId^> ^nodes);
      
  bool has_column_filters() { return _ref->has_column_filters(); }
  bool has_column_filter(int column) { return _ref->has_column_filter((::ColumnId) column); }
  String ^ get_column_filter_expr(int column)
  { return CppStringToNative(_ref->get_column_filter_expr((::ColumnId) column)); }
  void set_column_filter(int column, String ^filter_expr)
  { _ref->set_column_filter((::ColumnId) column, NativeToCppString(filter_expr)); }
  void reset_column_filter(int column) { _ref->reset_column_filter((::ColumnId) column); }
  void reset_column_filters() { _ref->reset_column_filters(); }
  int column_filter_icon_id() { return _ref->column_filter_icon_id(); }

  String ^ data_search_string() { return CppStringToNative(_ref->data_search_string()); }
  void set_data_search_string(String ^value) { _ref->set_data_search_string(NativeToCppString(value)); }
  void reset_data_search_string() { _ref->reset_data_search_string(); }

  void copy_rows_to_clipboard(List<int> ^indeces);
  void copy_field_to_clipboard(int row, int column) { _ref->copy_field_to_clipboard(row, column); }

  void data_storages_for_export(List<String ^> ^%formats_names, List<String ^> ^%formats_desc);
  Recordset_data_storage ^ data_storage_for_export(String ^format);

public:
  void refresh_ui_status_bar_cb(Refresh_ui_cb::ManagedDelegate ^cb);
private:
  Refresh_ui_cb ^_refresh_ui_status_bar_cb;
  sigc::connection *_refresh_ui_status_bar_conn;

public:
  GrtThreadedTask ^task;

public:
  List<MySQL::Grt::ToolbarItem^> ^get_toolbar_items();
public:
  List<MySQL::Grt::MenuItem^> ^get_popup_menu_items(List<int> ^rows, int column);
  bool activate_popup_menu_item(String ^action, List<int> ^rows, int column);
};


};  // namespace Db
};  // namespace Grt
};  // namespace MySQL


#endif // __RECORDSET_WR_H__
