/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#include "stdafx.h"

#include "Grt.h"
#include "GrtTemplates.h"
#include "sql_editor_wr.h"
#include "recordset_wr.h"


namespace MySQL {
namespace Grt {
namespace Db {
namespace Sql {


using namespace System;
using namespace System::Runtime::InteropServices;
using namespace System::Collections::Generic;


Sql_editor::Sql_editor(Ref ref)
:
_ref(ref), _search_replace_dialog(0)

{
}


Sql_editor::Sql_editor(IntPtr nref_ptr)
:
_ref(gcnew ManagedRef<::Sql_editor>(nref_ptr)), _search_replace_dialog(0)
{
}


Sql_editor::~Sql_editor()
{
  if (!(void*)~_ref)
    return;
  reset_fe_callbacks();
  delete _ref;
}


void Sql_editor::reset_fe_callbacks()
{
  if ((void*)~_ref)
  {
    _ref->replace_selected_text_slot.disconnect();
    _ref->insert_text_slot.disconnect();
    _ref->current_statement_slot.disconnect();
    _ref->report_sql_statement_border.disconnect();
    _ref->sql_parser_err_cb(::Sql_parser_base::Parse_error_cb());
  }

  delete _replace_selected_text_delegate;
  _replace_selected_text_delegate= nullptr;

  delete _insert_text_delegate;
  _insert_text_delegate= nullptr;

  delete _current_statement_delegate;
  _current_statement_delegate= nullptr;

  delete _do_search_delegate;
  _do_search_delegate= nullptr;

  delete on_report_sql_statement_border_delegate;
  on_report_sql_statement_border_delegate= nullptr;

  delete on_parse_err_delegate;
  on_parse_err_delegate= nullptr;

  delete on_eol_change_delegate;
  on_eol_change_delegate= nullptr;
}


int Sql_editor::int_option(String ^name)
{
  return _ref->int_option(NativeToCppString(name));
}


String ^ Sql_editor::string_option(String ^name)
{
  return CppStringToNative(_ref->string_option(NativeToCppString(name)));
}

//--------------------------------------------------------------------------------------------------

List<MySQL::Grt::MenuItem^>^ Sql_editor::get_context_menu()
{
  return CppVectorToObjectList<bec::MenuItem, MySQL::Grt::MenuItem>(_ref->get_context_menu());
}

//--------------------------------------------------------------------------------------------------

void Sql_editor::activate_context_menu_item(String^ action)
{
  _ref->activate_context_menu_item(NativeToCppString(action));
}

//--------------------------------------------------------------------------------------------------

void Sql_editor::get_sql_statement_border_by_line_pos(int lineno, int line_pos, int %stmt_begin_lineno, int %stmt_begin_line_pos, int %stmt_end_lineno, int %stmt_end_line_pos)
{
  ::Sql_editor::SqlStatementBorder sql_statement_border= _ref->get_sql_statement_border_by_line_pos(lineno, line_pos);
  stmt_begin_lineno= sql_statement_border.begin_lineno;
  stmt_begin_line_pos= sql_statement_border.begin_line_pos;
  stmt_end_lineno= sql_statement_border.end_lineno;
  stmt_end_line_pos= sql_statement_border.end_line_pos;
}


void Sql_editor::sql(String ^sql)
{
  _ref->sql(NativeToCppStringRaw(sql));
}


String ^ Sql_editor::sql()
{
  return CppStringToNativeRaw(_ref->sql());
}


String ^ Sql_editor::eol()
{
  const std::string &text= _ref->eol();
  return gcnew String(text.c_str(), 0, (int) text.size(), Encoding::UTF8);
}


void Sql_editor::eol_change_delegate(EolChangeDelegate::ManagedDelegate ^cb)
{
  on_eol_change_delegate= gcnew EolChangeDelegate(cb);
  _ref->eol_change_signal.connect(on_eol_change_delegate->get_slot());
}


};  // namespace Sql
};  // namespace Db
};  // namespace Grt
};  // namespace MySQL
