/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#include "stdafx.h"


namespace MySQL {
namespace Grt {


using namespace System;
using namespace System::Runtime::InteropServices;
using namespace System::Collections::Generic;
using namespace MySQL::Grt;


VarGridModel::VarGridModel(Ref ref)
:
GridModel((&ref).get()), //! temporary solution, update base classes to accept Ref in constructor
_ref(ref)
{}


VarGridModel::VarGridModel(IntPtr nref_ptr)
:
GridModel(((::VarGridModel::Ref*)(void*)(nref_ptr))->get()), //! temporary solution, update base classes to accept Ref in constructor
_ref(gcnew ManagedRef<::VarGridModel>(nref_ptr))
{
}


VarGridModel::~VarGridModel()
{
  if (!(void*)~_ref)
    return;
  delete _refresh_ui_cb;
  delete _ref;
}


void VarGridModel::refresh_ui_cb(Refresh_ui_cb::ManagedDelegate ^cb)
{
  if (cb != nullptr)
  {
    _refresh_ui_cb= gcnew Refresh_ui_cb(cb);
    _ref->refresh_ui_cb= _refresh_ui_cb->get_slot();
  }
  else
  {
    _refresh_ui_cb= nullptr;
    _ref->refresh_ui_cb= sigc::slot<int>();
  }
}


};  // namespace Grt
};  // namespace MySQL
