/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA 02110-1301  USA
 */

#ifndef __GRT_STRUCTS_TREE_H__
#define __GRT_STRUCTS_TREE_H__

namespace MySQL {
  namespace Grt {

    public ref class GrtStructsTree : public TreeModel
    {
    public:
      enum class DisplayMode {
        ByName = ::bec::StructsTreeBE::ByName,
        ByHierarchy = ::bec::StructsTreeBE::ByHierarchy,
        ByPackage = ::bec::StructsTreeBE::ByPackage
      };

      enum class Columns {
        Name = ::bec::StructsTreeBE::Name,
        Caption = ::bec::StructsTreeBE::Caption,
        Type = ::bec::StructsTreeBE::Type
      };

      GrtStructsTree(GRT^ grt)
        : TreeModel(new ::bec::StructsTreeBE(grt->get_unmanaged_object()))
      {}

      GrtStructsTree(::bec::StructsTreeBE *inn)
        : TreeModel(inn)
      {}

      inline ::bec::StructsTreeBE *get_unmanaged_object()
      { return static_cast<::bec::StructsTreeBE *>(inner); }

      //virtual int count_children(const NodeId &parent);
      //virtual NodeId get_child(const NodeId &parent, int index);

      //virtual bool get_field(const NodeId &node, int column, std::string &value);
      //virtual std::string get_field_description(const NodeId &node, int column);
      //virtual IconId get_field_icon(const NodeId &node, int column, IconSize size);

      // not for windows
      //bool get_row(const NodeId &node,
      //             IconId &caption_icon,
      //             std::string &name,
      //             std::string &caption,
      //             std::string &type);

      void set_display_mode(DisplayMode mode)
      { return get_unmanaged_object()->set_display_mode(static_cast<bec::StructsTreeBE::DisplayMode>(static_cast<int>(mode))); }
    };  

  } // namespace Grt
} // namespace MySQL

#endif // __GRT_STRUCTS_TREE_H__