@echo off

if "%1"=="" goto printUsage
if "%2"=="" goto printUsage
if "%3"=="" goto printUsage

rem Set edition specific variables
if "%1"=="com-se" set BIN_DIR=..\..\bin\Release
if "%1"=="com-se" set LICENSE_TYPE=commercial
if "%1"=="com-se" set SETUP_TYPE=com-se

if "%1"=="gpl" set BIN_DIR=..\..\bin\Release_OSS
if "%1"=="gpl" set LICENSE_TYPE=gpl
if "%1"=="gpl" set SETUP_TYPE=gpl

rem Set version variables
set VERSION_MAIN=5.2
set VERSION_DETAIL=%2

if "%3"=="a" set BUILD_LEVEL=-alpha
if "%3"=="b" set BUILD_LEVEL=-beta
if "%3"=="r" set BUILD_LEVEL=-rc
if "%3"=="i" set BUILD_LEVEL=-internal

rem Set other variables
set DIST_DIR=.\distribution
set UTIL_PATH=..\..\..\mysql-gui-win-res\bin
set OUTPUT_FILENAME=mysql-workbench-%SETUP_TYPE%-%VERSION_DETAIL%%BUILD_LEVEL%-win32.msi

if not exist %BIN_DIR% goto ERROR
if not exist %DIST_DIR% mkdir %DIST_DIR%


rem -------------------------------------------------------------------------------------
echo Copy Editions specific files...
echo .
if "%1"=="com-se" copy ..\res\MySQLEULA.* %BIN_DIR%\. 1> nul
if "%1"=="gpl" copy ..\res\COPYING %BIN_DIR%\. 1> nul

rem -------------------------------------------------------------------------------------
echo Copy Documentation...
echo .
copy ..\res\docs\workbench.chm %BIN_DIR%\MySQLWorkbench.chm 1> nul

rem -------------------------------------------------------------------------------------
echo Make Setup script started...
echo .

echo Clean old object files ...
rem Cleaning is necessary because *.wixobj files must be remade if the license
rem type changes.
nmake /NOLOGO -f Makefile.mak clean
echo .

rem -------------------------------------------------------------------------------------
echo Copying WiX source files ...
copy source\mysql_workbench.xml mysql_workbench.xml
copy source\mysql_workbench_fragment.xml mysql_workbench_fragment.xml
echo .


echo Build MSI file...
nmake /NOLOGO -f Makefile.mak LICENSE_TYPE=%LICENSE_TYPE% SETUP_TYPE=%SETUP_TYPE% all VERSION_MAIN=%VERSION_MAIN% VERSION_DETAIL=%VERSION_DETAIL%
if errorlevel 1 goto ERROR4
echo .
echo MSI file build successfully.
echo .

rem move generated file
move mysql_workbench.msi %DIST_DIR%\%OUTPUT_FILENAME%

pushd %DIST_DIR%
echo Make .md5 sum ...
..\%UTIL_PATH%\md5sum %OUTPUT_FILENAME% > %OUTPUT_FILENAME%.md5
echo .
popd

echo Clean object files...
call MakeClean.bat
echo .

echo Build was successful. You can find the generated files in the %DIST_DIR% directory.

EXIT /B 0


:ERROR
echo Error: You have to provide a build in the %BIN_DIR% directory
EXIT /B 0

:ERROR2
echo Error: set_shell_vars.cmd cannot be generated
EXIT /B 0

:ERROR3
echo Error: The directory %SOURCE_DIR% has to contain the files from the .zip distribution
EXIT /B 0

:ERROR4
echo Error: Building the setup-files failed. Error messages should have been provided above.
EXIT /B 0

:printUsage
echo MakeSetup Version 2.0.0
echo Usage:
echo .
echo %0 EDITION VERSION BUILD_LEVEL
echo .
echo   EDITION can be com-se or gpl
echo   VERSION has to be a 3 number version code, starting with 5.0
echo   BUILD_LEVEL can be a (=alpha), b (=beta), r (=rc), g (=ga) , i (=internal)
echo .
echo   Examples:
echo   %0 ce 5.0.8 b
