/* 
 * Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _EDIT_TABLE_DATA_WIZARD_H_
#define _EDIT_TABLE_DATA_WIZARD_H_

#include "grt/common.h"
#include "grtui/grt_wizard_form.h"
#include "grtui/connection_page.h"
#include "wb_context.h"

/**
 * Implementation of a wizard to edit table data.
 */

using namespace grtui;
using namespace mforms;

class TableSelectionPage : public WizardPage
{
public:
  TableSelectionPage(WizardForm* host);

protected:
  void schema_changed();
  void table_changed();

protected:
  virtual void enter(bool advancing);
  virtual void do_validate();
  virtual bool allow_next();
  virtual bool advance();
  virtual std::string next_button_caption();

private:
  Label _schema_selector_heading;
  Label _schema_selector_caption;
  Table _schema_selector_table;
  Box _schema_selector_contents;
  Selector _schema_selector;

  Label _table_selector_heading;
  Label _table_selector_caption;
  Table _table_selector_table;
  Box _table_selector_contents;
  Selector _table_selector;

  Label _last_message;

  mforms::Panel _log_panel;
  mforms::TextBox _log_text;

private:
  DbConnection *_db_conn;
  wb::WBContext* _context;
public:
  void set_db_connection(DbConnection *value);
  void set_context(wb::WBContext* context);
};

class EditTableDataWizard : public WizardForm
{
public:
  EditTableDataWizard(wb::WBContext* context);
  ~EditTableDataWizard();

private:
  TableSelectionPage* _table_selection_page;
  ConnectionPage* _db_conn_page;
private:
  DbConnection _db_conn;
  wb::WBContext* _context;
};

#endif // _EDIT_TABLE_DATA_WIZARD_H_
