/* 
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef __grt_code_editor_h__
#define __grt_code_editor_h__

#include <mforms/mforms.h>

class GRTShellWindow;

class GRTCodeEditor : public mforms::Splitter
{
public:
  GRTCodeEditor(GRTShellWindow *owner, bool module, const std::string &language);

  void set_path(const std::string &path);
  const std::string& get_path() { return _filename; };
  void set_text(const std::string &text);
  std::string get_title();
  
  bool can_close();
protected:
  GRTShellWindow *_owner;
  mforms::Box _top;
  mforms::Box _toolbar;
#ifdef _WIN32
  mforms::CodeEditor _text;
#else
  mforms::TextBox _text;
#endif
  mforms::TextBox _output;

  std::string _filename;
  std::string _language;
  bool _editing_module;
  bool _dirty;
  
  void add_output(const std::string &text);
  void text_changed();
  
  void close();
  bool save(bool choose_file);
  void execute();
  void add_tool_button(const std::string &image,
                       const sigc::slot<void> &action,
                       const std::string &tooltip,
                       bool left=true);
};



#endif /* __grt_code_editor.h__ */
