
#include "diagram_size_form.h"
#include "linux_utilities/MGGladeXML.h"
#include "workbench/wb_context_ui.h"
#include "model/wb_diagram_options.h"
#include "gtk/mdc_gtk_canvas_view.h"
#include <gtkmm/spinbutton.h>
#include <gtkmm/frame.h>


DiagramSizeForm::DiagramSizeForm(GtkDialog *gobj)
  : Gtk::Dialog(gobj)
{
  _be= 0;
  _xml= 0;
}


DiagramSizeForm::~DiagramSizeForm()
{
  delete _be;
  delete _xml;
}


void DiagramSizeForm::spin_changed()
{
  Gtk::SpinButton *spin;
  _xml->get("spinbutton1", &spin);
  _be->set_xpages(spin->get_value());

  _xml->get("spinbutton2", &spin);
  _be->set_ypages(spin->get_value());
}


void DiagramSizeForm::changed()
{
  Gtk::SpinButton *spin;
  _xml->get("spinbutton1", &spin);
  spin->set_value(_be->get_xpages());
  
  _xml->get("spinbutton2", &spin);
  spin->set_value(_be->get_ypages());
}


void DiagramSizeForm::realize_be(wb::WBContextUI *wbui)
{
  _be= wbui->create_diagram_options_be(_canvas->get_canvas());
  _be->update_size();
  
  _be->signal_changed().connect(sigc::mem_fun(this, &DiagramSizeForm::changed));

  Gtk::SpinButton *spin;
  _xml->get("spinbutton1", &spin);
  spin->set_value(_be->get_xpages());
  spin->signal_changed().connect(sigc::mem_fun(this, &DiagramSizeForm::spin_changed));
  
  _xml->get("spinbutton2", &spin);
  spin->set_value(_be->get_ypages());
  spin->signal_changed().connect(sigc::mem_fun(this, &DiagramSizeForm::spin_changed));
  
  _xml->get<Gtk::Entry>("name_entry")->set_text(_be->get_name());

  Gtk::Button *btn;
  _xml->get("button1", &btn); // ok
  btn->signal_clicked().connect(sigc::mem_fun(this, &DiagramSizeForm::ok_clicked));
}


void DiagramSizeForm::ok_clicked()
{
  _be->set_name(_xml->get<Gtk::Entry>("name_entry")->get_text());
  
  _be->commit();
}


void DiagramSizeForm::init(wb::WBContextUI *wbui, MGGladeXML *xml)
{  
  _xml= xml;

  Gtk::Frame *frame= 0;

  _xml->get("frame", &frame);

  _canvas= Gtk::manage(new mdc::GtkCanvas(mdc::GtkCanvas::BufferedXlibCanvasType));
  frame->add(*_canvas);
  _canvas->show();

  _canvas->signal_realize().connect_notify(sigc::bind(sigc::mem_fun(this, &DiagramSizeForm::realize_be), wbui));
}


DiagramSizeForm *DiagramSizeForm::create(wb::WBContextUI *wbui)
{
  MGGladeXML *ui= new MGGladeXML(wbui->get_wb()->get_grt_manager()->get_data_file_path("diagram_size_form.glade").c_str(), "", "");
  
  DiagramSizeForm *panel= 0;

  ui->get_widget_derived<DiagramSizeForm>("dialog", panel);

  if (panel)
    panel->init(wbui, ui);

  return panel;
}


