/* 
 * (c) 2009-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#import <Cocoa/Cocoa.h>

#import "MScintillaView.h"
#import "InfoBar.h"

#import "WBPluginBase.h"
#import "sql_editor_be.h"

//! Base class for editor plugins. Must return the view to be docked in the main window
//! in dockableView.
@interface WBPluginEditorBase : WBPluginBase {
  NSSize mMinumumSize;
}

- (id)identifier;
- (NSString*)title;
- (NSImage*)titleIcon;
- (void)updateTitle:(NSString*)title;

- (void)reinitWithArguments:(const grt::BaseListRef&)args;

- (void)refresh;

- (NSView*)dockableView;

- (void)setMinimumSize:(NSSize)size;
- (NSSize)minimumSize;

- (bec::BaseEditor*)editorBE;

- (BOOL)matchesIdentifierForClosingEditor:(NSString*)identifier;

- (BOOL)pluginWillClose:(id)sender;

- (void)applyLiveChanges;
- (void)revertLiveChanges;

+ (void)setupCodeEditor: (MScintillaView*) editor backend: (Sql_editor::Ref) backend withStatus: (BOOL) withStatus;

@end
