/* 
 * Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#import <Cocoa/Cocoa.h>
#import "WBBasePanel.h"


#include "sqlide/wb_sql_editor_form.h"

@class ScintillaView;
@class MSQLEditorController;
@class MTogglePane;
@class MResultsetViewer;
@class WBQuerySidebarController;
@class MVerticalLayoutView;
@class WBSplitView;
@class WBSplitViewUnbrokenizerDelegate;
@class WBOverviewPanel;
@class WBMiniToolbar;
@class GRTListDataSource;

@interface WBSQLQueryPanel : WBBasePanel
{
  IBOutlet WBSplitView* mView;
  IBOutlet WBSplitView* mWorkView;
  IBOutlet WBSplitViewUnbrokenizerDelegate* mSplitterDelegate;
  
  IBOutlet NSTabView* mOutputTabView;
  IBOutlet NSSegmentedControl* mOutputSegmented;
  IBOutlet NSTextView* mTextOutput;
  
  IBOutlet NSTableView* mMessagesTable;
  IBOutlet NSTableView* mHistoryTable;
  IBOutlet NSTableView* mHistoryDetailsTable;
  IBOutlet NSButton* mClearAllButton;

  IBOutlet NSTextView* mOutputActionText;
  IBOutlet NSTextView* mOutputResponseText;

  IBOutlet NSTabView* mUpperTabView;
  IBOutlet NSTabView* mLowerTabView;
  IBOutlet WBQuerySidebarController *mSidebar;
  IBOutlet NSView *mSidebarView;
  
  IBOutlet WBMiniToolbar* mOverviewToolbar;
  IBOutlet WBMiniToolbar* mSnippetsToolbar;
  
  IBOutlet NSTableView *snippetTable;
  IBOutlet GRTListDataSource *snippetDS;
  IBOutlet ScintillaView *mSnippetText;

  IBOutlet NSPopUpButton *mSchemaPop;
  
  NSTimeInterval mLastClick;
  
  BOOL mQueryAreaOpen;
  BOOL mResultsAreaOpen;
  
  WBOverviewPanel *mOverview;

  NSMutableArray *mEditors;
  
  NSMutableArray *mResultsetViews;
  
  Db_sql_editor::Ref mBackEnd;
  
  NSLock *mTextOutputLock;
  std::string mTextOutputBuffer;
  
  BOOL sidebarHidden;
  BOOL sidebarAtRight;
  CGFloat lastSidebarWidth;
}

- (IBAction)activateHistoryEntry:(id)sender;
- (IBAction)clearOutput:(id)sender;

- (void)executeQuery:(id)sender currentStatementOnly: (bool) currentStatementOnly;
- (id)initWithBE:(const Db_sql_editor::Ref&)be;
- (Db_sql_editor::Ref)backEnd;
- (MResultsetViewer*)selectedResultset;
- (MSQLEditorController*)activeEditor;
- (void)addEditorTab;
- (void)addEditorTabWithBackEndIndex:(int)index;
- (void)setRightSidebar:(BOOL)flag;
- (void)flushOutputBuffer;
@end


