//
//  GRTIconCache.h
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 12/Oct/08.
//  Copyright 2008 Sun Microsystems Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "sigobjc++.h"
#include "grt/icon_manager.h"

@interface GRTIconCache : NSObject {
  std::map<bec::IconId, NSImage*> *_cache;
  NSImage *_folderIcon16;
}

+ (GRTIconCache*)sharedIconCache;

- (NSImage*)imageForFolder:(bec::IconSize)size;
- (NSImage*)imageForFileName:(NSString*)fname;
- (NSImage*)imageForIconId:(bec::IconId)icon;
- (NSImage*)uncachedImageForIconId:(bec::IconId)icon;

@end
