using System;
using System.Windows.Forms;

using MySQL.Grt;
using MySQL.Workbench;

namespace MySQL.GUI.Workbench.Plugins
{
	public delegate void WorkbenchDocumentClosing(Object sender, FormClosingEventArgs e);

	public interface IWorkbenchDocument
	{
    // Event that should be called from document when it is closing
		WorkbenchDocumentClosing OnWorkbenchDocumentClosing { get; set; }

    // Function that returns a pointer to the backend used
    UIForm BackendClass { get; }

    // Refresh command for a specific workbench document.
    void RefreshGUI(RefreshType refresh, String str, IntPtr ptr);

    // General command handling.
    void PerformCommand(String command);

    // Plugin handling.
    // Return the first plugin found of a given type.
    DockablePlugin FindPluginOfType(Type type);

    // Close the first plugin of a given type.
    bool ClosePluginOfType(Type type);
	}
}
