/*
 *  mdc_box_handle.cpp
 *  mdcanvas
 *
 *  Created by Alfredo Kojima on 07/May/1.
 *  Copyright 2007 MySQL AB. All rights reserved.
 *
 */

#include "stdafx.h"

#include "mdc_box_handle.h"

using namespace mdc;

BoxHandle::BoxHandle(InteractionLayer *ilayer, CanvasItem *item, const Point &pos)
: ItemHandle(ilayer, item, pos)
{
  set_color(Color(1,1,1));
}


BoxHandle::~BoxHandle()
{
}


mdc::Rect BoxHandle::get_bounds() const
{
  Rect r;
  if (_draggable)
  {
    r.pos.x= _pos.x - 3.5;
    r.pos.y= _pos.y - 3.5;
    r.size.width= 8;
    r.size.height= 8;
  }
  else
  {
    r.pos.x= _pos.x - 2.5;
    r.pos.y= _pos.y - 2.5;
    r.size.width= 6;
    r.size.height= 6;
  }
  return r;
}
