
#ifndef _MDC_GROUP_H_
#define _MDC_GROUP_H_

#include "mdc_layouter.h"

BEGIN_MDC_DECLS

class Layer;
  
class MYSQLCANVAS_PUBLIC_FUNC Group : public Layouter {
public:
  Group(Layer *layer);
  virtual ~Group();
  
  virtual void dissolve();

  virtual void add(CanvasItem *item);
  virtual void remove(CanvasItem *item);

  bool has_item(CanvasItem *item);
  std::list<CanvasItem*> &get_contents() { return _contents; };
  bool empty() const { return _contents.empty(); };

  virtual void foreach(const sigc::slot<void, CanvasItem*> &slot);

  void freeze();
  void thaw();

  CanvasItem *get_direct_subitem_at(const Point &point);
  virtual CanvasItem *get_other_item_at(const Point &point, CanvasItem *item);
  virtual CanvasItem *get_item_at(const Point &point);  
  
  virtual void move_item(CanvasItem *child_item, const Point &pos);
  
  virtual void raise_item(CanvasItem *item, CanvasItem *above= 0);
  virtual void lower_item(CanvasItem *item);
  
  virtual void move_to(const Point &point);

  virtual void set_selected(bool flag);
    
  virtual void repaint(const Rect &clipArea, bool direct);

protected:
  struct ItemInfo
  {
    sigc::connection connection;
  };
    
  // front of list is top stack
  std::list<CanvasItem*> _contents;

  std::map<CanvasItem*, ItemInfo> _content_info;
  int _freeze_bounds_updates;
#ifdef no_group_activate
  bool _activated;
#endif

  virtual void update_bounds();
  
  void focus_changed(bool f, CanvasItem *item);
#ifdef no_group_activate
  void activate_group(bool flag);
#endif
};

END_MDC_DECLS

#endif /* _MDC_GROUP_H_ */
