#ifndef _MDC_LAYER_H_
#define _MDC_LAYER_H_


#include "mdc_common.h"
#include "mdc_group.h"
#include "mdc_events.h"

BEGIN_MDC_DECLS

class CanvasView;
class CanvasItem;
class AreaGroup;

class MYSQLCANVAS_PUBLIC_FUNC Layer : public sigc::trackable
{
public:
  Layer(CanvasView *view);
  virtual ~Layer();

  void set_root_area(AreaGroup *group);
  
  void set_name(const std::string &name);
  std::string get_name() const { return _name; }

  virtual void add_item(CanvasItem *item, AreaGroup *location= 0);
  virtual void remove_item(CanvasItem *item);
  
  virtual void set_visible(bool flag);
  bool visible() const { return _visible; };

  virtual void repaint_pending();
  virtual void repaint(const Rect &aBounds);
  void repaint_for_export(const Rect &aBounds);

  inline CanvasView *get_view() const { return _owner; };

  void queue_relayout(CanvasItem *item);
  void invalidate_caches();

  void set_needs_repaint_all_items();

  void queue_repaint();
  void queue_repaint(const Rect &bounds);
  
  CanvasItem *get_other_item_at(const Point &point, CanvasItem *item);
  
  CanvasItem *get_item_at(const Point &point);
  CanvasItem *get_top_item_at(const Point &point);

  AreaGroup *get_root_area_group() const { return _root_area; }

  typedef sigc::slot<bool,CanvasItem*> ItemCheckFunc;

  std::list<CanvasItem*> get_items_bounded_by(const Rect &rect, 
                                              const ItemCheckFunc &pred= ItemCheckFunc(),
                                              mdc::Group *inside_group= 0);

  
  Group *create_group_with(const std::list<CanvasItem*> &contents);
  void dissolve_group(Group *group);

  AreaGroup *create_area_group_with(const std::list<CanvasItem*> &contents);

  Rect get_bounds_of_item_list(const std::list<CanvasItem*> &items);

protected:
  CanvasView *_owner;
  AreaGroup *_root_area;
  
  std::string _name;

  std::list<CanvasItem*> _relayout_queue;

  bool _visible;

  bool _needs_repaint;
  
  Layer *get_layer_under_this();
private:
  void view_resized();
};

  
END_MDC_DECLS


#endif /* _MDC_LAYER_H_ */
