/*
 *  mdc_vertex_handle.cpp
 *  mdcanvas
 *
 *  Created by Alfredo Kojima on 07/May/1.
 *  Copyright 2007 MySQL AB. All rights reserved.
 *
 */

#include "stdafx.h"

#include "mdc_vertex_handle.h"

using namespace mdc;

VertexHandle::VertexHandle(InteractionLayer *ilayer, CanvasItem *item, const Point &pos, bool connectable)
: ItemHandle(ilayer, item, pos), _connectable(connectable)
{
}


VertexHandle::~VertexHandle()
{
}


void VertexHandle::repaint(CairoCtx *cr)
{
  Rect r= get_bounds();
  
  cr->set_color(Color(1, 1, 1, 0.8));
  cr->set_line_width(1);
  if (_connectable)
  {
    cr->move_to(r.xmin() + r.width()/2, r.ymin());
    cr->line_to(r.xmin(), r.ymin() + r.height()/2);
    cr->line_to(r.xmin() + r.width()/2, r.ymax());
    cr->line_to(r.xmax(), r.ymin() + r.height()/2);
    cr->close_path();
  }
  else
  {
    cr->rectangle(r);
  }
  cr->fill_preserve();
  
  if (_highlighted)
    cr->set_color(Color(0, 1, 1, 1));
  else
    cr->set_color(Color(0.0, 0.0, 0.9, 1));
  cr->stroke();
}


mdc::Rect VertexHandle::get_bounds() const
{
  Rect r;
  r.pos.x= _pos.x - 4.5;
  r.pos.y= _pos.y - 4.5;
  r.size.width= 9;
  r.size.height= 9;
  return r;
}

