//
//  MFScrollPanel.mm
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 9/Feb/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import "MFScrollPanel.h"

#import "MFView.h"
#include "mforms/mforms.h"

@interface MFClipView : NSClipView
{
}

@end

// Need to override the clipview so that the layout methods can get called by content
@implementation MFClipView

- (void)subviewMinimumSizeChanged
{
  [self resizeSubviewsWithOldSize: NSMakeSize(0, 0)];
}

- (void)resizeSubviewsWithOldSize:(NSSize)oldBoundsSize
{  
  NSSize size; //= [[self documentView] frame].size;
  NSSize psize= [[self documentView] preferredSize];

  size.width= NSWidth([self frame]);
  //size.height= NSHeight([self frame]);
  size.height= [[self documentView] minimumSize].height;

  size.width = MAX(size.width, psize.width);
  size.height = MAX(size.height, psize.height);

  [[self documentView] setFrameSize: size];
}

@end


@implementation MFScrollPanelImpl

- (id)initWithObject:(::mforms::ScrollPanel*)aScrollPanel 
            bordered: (bool) bordered
     drawsBackground: (bool) drawBG
{
  self= [super initWithFrame:NSMakeRect(0, 0, 10, 20)];
  if (self)
  {
    [self setHasVerticalScroller: YES];
    
    [self setContentView: [[[MFClipView alloc] initWithFrame: NSMakeRect(0, 0, 10, 20)] autorelease]];

    [self setDrawsBackground: drawBG];
    if (bordered)
      [self setBorderType: NSLineBorder];
    [self setAutohidesScrollers: YES];
    
    mOwner= aScrollPanel;
    mOwner->set_data(self);
  }
  return self;
}


- (NSSize)minimumSize
{
  return [NSScrollView frameSizeForContentSize:NSMakeSize(50, 50)
                         hasHorizontalScroller:YES
                           hasVerticalScroller:YES
                                    borderType:NSLineBorder];
}


- (void)subviewMinimumSizeChanged
{
  NSSize minSize= [self minimumSize];
  NSSize size= [self frame].size;
  
  // size of some subview has changed, we check if our current size is enough
  // to fit it and if not, request forward the size change notification to superview
  
  if (minSize.width > size.width || minSize.height > size.height)
  {
    if ([self superview])
    {
      [[self superview] subviewMinimumSizeChanged];
      return;
    }
    else
      [self setFrameSize: minSize];
  }
  [self resizeSubviewsWithOldSize:size];
}

- (void)setTag:(NSInteger)tag
{
  mTag= tag;
}

- (NSInteger)tag
{
  return mTag;
}

- (void) setBackgroundColor: (NSColor*) color
{
  [super setBackgroundColor: color];
}

static bool scrollpanel_create(::mforms::ScrollPanel *self, mforms::ScrollPanelFlags flags)
{
  [[[MFScrollPanelImpl alloc] initWithObject:self 
                                    bordered: flags & mforms::ScrollPanelBordered
                             drawsBackground: flags & mforms::ScrollPanelDrawBackground] autorelease];
  
  return true;  
}


static void scrollpanel_add(mforms::ScrollPanel *self, mforms::View *child)
{
  MFScrollPanelImpl *panel= self->get_data();
  if (panel)
    [[panel contentView] setDocumentView: child->get_data()];
}


static void scrollpanel_remove(mforms::ScrollPanel *self)
{
  MFScrollPanelImpl *panel= self->get_data();
  if (panel)
    [panel setDocumentView:nil];
}


static void scrollpanel_set_visible_scrollers(mforms::ScrollPanel *self, bool vertical, bool horizontal)
{
  MFScrollPanelImpl *panel= self->get_data();

  [panel setHasVerticalScroller:vertical];
  [panel setHasHorizontalScroller:horizontal];
}


static void scrollpanel_set_autohide_scrollers(mforms::ScrollPanel *self, bool flag)
{
  MFScrollPanelImpl *panel= self->get_data();
  
  [panel setAutohidesScrollers: flag];
}


void cf_scrollpanel_init()
{
  ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();
  
  f->_spanel_impl.create= &scrollpanel_create;
  f->_spanel_impl.add= &scrollpanel_add;
  f->_spanel_impl.remove= &scrollpanel_remove;
  f->_spanel_impl.set_visible_scrollers= &scrollpanel_set_visible_scrollers;
  f->_spanel_impl.set_autohide_scrollers= &scrollpanel_set_autohide_scrollers;
}


@end

