/* 
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>

#import "MFView.h"
#import "mforms/WebBrowser.h"


@interface MFWebBrowserImpl : NSView {
  mforms::WebBrowser* mOwner;
  WebView* mBrowser;
  NSInteger mTag;
}

- (id) initWithObject:(mforms::WebBrowser*) aBrowser;
- (void) setHTML: (NSString*) code;
- (void) navigate: (NSString*) url;
- (NSString*) documentTitle;

- (NSInteger) tag;
- (void) setTag: (NSInteger) tag;

@end
